
/* Copyright (C) 2001-2007 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* fs_fio.c */


#include "fs_itype.h"

/****************************************************************/
FS_FILE *FS_open(_DS_ FILECHAR *path)
{
    FS_FILE *fp;

    fp = SYS_FOPEN(path, "rb");
    if (fp == 0)
    {
#ifdef FS_DEBUG
        FS_PRINTF(( "*** unable to open '%s'\n", path));
#endif

        STATE.error = ERR_FILE_OPEN;
        return 0;
    }

    return fp;
}

/****************************************************************/
FS_VOID FS_close(_DS_ FS_FILE *fp)
{
    if (0 != SYS_FCLOSE(fp))
    {
        STATE.error = ERR_FILE_CLOSE;
    }
}

/****************************************************************/
FS_LONG FS_seek(_DS_ FS_FILE *fp, FS_ULONG offset, int whence)
{
    /* why couldn't this return the offset ... like _lseek() */
    if (0 != SYS_FSEEK(fp, offset, whence))
    {
#ifdef FS_DEBUG
        FS_PRINTF(( "*** FS_seek => %d\n", SYS_FERROR(fp)));
#endif

        return STATE.error = ERR_FILE_SEEK;
    }
    return SUCCESS;
}

/****************************************************************/
FS_ULONG FS_read(_DS_ FS_FILE *fp, FS_BYTE *buf, FS_ULONG size)
{
    FS_ULONG r;
    FS_ULONG myerrcode;
    FS_ULONG eof = (FS_ULONG)EOF;

    r = SYS_FREAD(buf, 1, size, fp);
    if (r != size)
    {

#ifdef FS_DEBUG
        FS_PRINTF(( "*** FS_read => %d\n", SYS_FERROR(fp) ));
#endif
        myerrcode = SYS_FERROR(fp);

        /* reading off the end of file isn't NECESSARILY an error */
        if (myerrcode != eof)
        {
            STATE.error = ERR_FILE_READ;
        }
    }
    return r;
}
